#ifndef DTREEVIEWDIRECTORIOS_H
    #define DTREEVIEWDIRECTORIOS_H

    #include "DTreeView.h"
    #include "DImageList.h"

    namespace DWL {
        enum DEnum_TreeViewDirectorios_Nodo_Tipo {
            DEnum_TreeViewDirectorios_Nodo_Tipo_Escritorio = 0,
            DEnum_TreeViewDirectorios_Nodo_Tipo_MiPC,
            DEnum_TreeViewDirectorios_Nodo_Tipo_Disquetera,
            DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoDuro,
            DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoDuroRed,
            DEnum_TreeViewDirectorios_Nodo_Tipo_CDROM,
            DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoRam,
            DEnum_TreeViewDirectorios_Nodo_Tipo_Directorio,
            DEnum_TreeViewDirectorios_Nodo_Tipo_MisDocumentos,
            DEnum_TreeViewDirectorios_Nodo_Tipo_MisSitiosRed,
            DEnum_TreeViewDirectorios_Nodo_Tipo_RedMicrosoft,
            DEnum_TreeViewDirectorios_Nodo_Tipo_GrupoTrabajo,
            DEnum_TreeViewDirectorios_Nodo_Tipo_Servidor,
            DEnum_TreeViewDirectorios_Nodo_Tipo_Desconocido
        };

        class DTreeViewDirectorios_Nodo : public DTreeView_Nodo {
          public:
                                                    DTreeViewDirectorios_Nodo(const DEnum_TreeViewDirectorios_Nodo_Tipo nTipo, const bool nActivado) : Tipo(nTipo), Activado(nActivado) { };
            DEnum_TreeViewDirectorios_Nodo_Tipo     Tipo;
            bool                                    Activado;
        };

        class DTreeViewDirectorios : public DTreeView {
          public :
                                DTreeViewDirectorios(void) { };
                               ~DTreeViewDirectorios(void) { };

						        //
						        //! Funcin para crear el TreeView.
						        // HWND Crear(DWORD Estilos, HWND hWndPadre, const int cX, const int cY, const int cAncho, const int cAlto, const int cID, DWORD EstilosExtendidos = NULL);
		    HWND	            Crear(DBaseWnd *Padre, const int cX, const int cY, const int cAncho, const int cAlto, const int cID, DWORD nEstilos, DWORD nEstilosExtendidos = NULL);
						        //
						        //! Funcin para asignar esta clase a un TreeView creado anteriormente en el editor de recursos.
						        // void Asignar(HWND hWndPadre, const int cID);
		    void	            Asignar(DBaseWnd *Padre, const int cID);

                                // 
                                // Funcion para mostrar o ocultar las redes. Por defecto las redes se muestran.
                                // Si no quieres mostrar las redes debes llamar esta funcion antes de Crear o Asignar para que ActualizarDirectorios lo tenga en cuenta.
                                // Tambien puedes utilizar ActualizarDirectorios una vez creado / asignado el control, pero piensa que realmente se habra actualizado 2 veces.
            inline void         MostrarRedes(const bool nMostrar) { _MostrarRedes = nMostrar; };

            HTREEITEM           AgregarNodoDirectorio(const DEnum_TreeViewDirectorios_Nodo_Tipo Tipo, HTREEITEM Parent, const TCHAR *cTexto, const int cIko, HTREEITEM InsertarDespuesDe = NULL, const bool nActivado = true);

            void                ActualizarDirectorios(void);

            void                ObtenerPathSeleccionado(DString &nPath);

            void                TreeView_Evento_Nodo_Expandiendo(DTreeView_Nodo *nNodo);
                                                //! Funcin que devuelve que tipo de clase BaseWnd es esta clase
                                                /*! Esta funcin devuelve que tipo de clase BaseWnd es esta clase
                                                        \fn         virtual const DEnum_TipoBaseWnd TipoBaseWnd(void);
                                                        \returns    Devuelve un valor de DEnum_TipoBaseWnd
                                                        \remars     Esta funcin identifica que tipo de ventana o control se esta utilizando.
                                                */
            virtual const DEnum_TipoBaseWnd     TipoBaseWnd(void)   { return DEnum_TipoBaseWnd_TreeViewDirectorios; };
          protected :
            const bool         _TieneDirectorios(const TCHAR *nPath, bool &TieneArchivos);
            void               _ObtenerPath(DTreeViewDirectorios_Nodo *nNodo, DString &nPath);
            void               _AgregarDirectorio(DTreeViewDirectorios_Nodo *nNodoExpandido, const TCHAR *PathBusqueda);
            const bool         _ComprobarPath(const TCHAR *nPath);
            void               _EnumerarRed(LPNETRESOURCE lpnr, DTreeView_Nodo *nNodo);

//            DImageListSistema  _ImageList;
            DImageList         _ImageList;

            bool               _MostrarRedes;
        };
    };


#endif